<?php

namespace App\Http\Controllers\Admin\Package;

use App\DataTables\PackageDataTable;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Packages\Package;

class PackageController extends Controller
{
    public function index(PackageDataTable $table)
    {
        return $table->render('admin.package.index');
    }

    public function create()
    {
        return view('admin.package.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'image' => 'required',
            'banner' => 'required',
            'name' => 'required',
            'group_id' => 'required',
            'duration' => 'required',
            'status' => 'required',
            'discount_type' => 'required|string',
            'description' => 'required',
        ]);

        $data = request()->all();

        if (!isset($data['discount'])) {
            unset($data['discount']);
        }

        $data['image'] = $this->fileService->store('image', 'packages');
        $data['banner'] = $this->fileService->store('banner', 'packages');

        Package::query()->create($data);

        return redirect()->route('packages.index')->with('success', 'Package Created Successfully!');
    }

    public function edit(Package $package)
    {
        return view('admin.package.edit', compact('package'));
    }

    public function update(Request $request, Package $package)
    {
        $request->validate([
            'name' => 'required',
            'group_id' => 'required',
            'duration' => 'required',
            'status' => 'required',
            'discount_type' => 'required|string',
            'description' => 'required',
        ]);

        $data = request()->all();
        $data['image'] = $this->fileService->checkAndStore('image', 'packages', $package->image);
        $data['banner'] = $this->fileService->checkAndStore('banner', 'packages', $package->image);

        $package->update($data);

        return redirect()->route('packages.index')->with('success', 'Package Update Successfully!');
    }

    public function destroy(Package $package)
    {
        $this->fileService->delete($package->image);
        $this->fileService->delete($package->banner);

        $package->delete();

        return redirect()->route('packages.index')->with('info', 'Package Deleted!');
    }
}
