<?php

namespace App\Http\Controllers\Admin\Order;

use App\Models\Orders\Order;
use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;


class OrderController extends Controller
{
    public function index()
    {
        return view('admin.order.index');
    }

    public function edit(Order $order)
    {
        $status = [
            Order::ORDER_PENDING,
            Order::ORDER_CONFIRMED,
            Order::ORDER_FAILED,
            Order::ORDER_ACTIVE,
            Order::ORDER_COMPLETED,
        ];

        return view('admin.order.edit', compact('order', 'status'));
    }

    public function update(Request $request, Order $order): RedirectResponse
    {
        if (isset($request->status)) {
            $order->update(['status' => $request->status]);
            return back()->with('success', 'Status Updated Successfully!');
        }

        $data = $request->all();
        $order->update($data);

        return redirect()->route('')->with('success', 'Status Updated Successfully!');
    }

    public function destroy(Order $order)
    {
        $order->delete();

        return back()->with('info', 'Order Deleted!');
    }
}
