<?php

namespace App\Http\Controllers\Admin\Deal;

use App\DataTables\DealDataTable;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Deals\Deal;

class DealController extends Controller
{
    public function index(DealDataTable $table)
    {
        return $table->render('admin.deal.index');
    }

    public function create()
    {

        return view('admin.deal.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'status' => 'required',
        ]);

        $data = $request->all();

        if (!isset($data['sort'])) {
            unset($data['sort']);
        }

        Deal::create($data);

        return redirect()->route('deals.index')->with('success', 'Deal Created Successfully!');
    }

    public function show($id)
    {
        //
    }

    public function edit(Deal $deal)
    {
        return view('admin.deal.edit', compact('deal'));
    }

    public function update(Request $request, Deal $deal)
    {
        $request->validate([
            'name' => 'required',
            'status' => 'required',
        ]);

        $data = $request->all();

        if (!isset($data['sort'])) {
            unset($data['sort']);
        }

        $deal->update($request->all());

        return redirect()->route('deals.index')->with('success', 'Deal Updated Successfully');
    }

    public function destroy(Deal $deal)
    {
        $deal->delete();

        return back()->with('info', 'Deal Deleted!');
    }
}
