<?php

namespace App\Http\Controllers\Admin;

use App\Models\Orders\Order;
use App\Models\Products\Product;
use App\Models\Categories\Category;
use App\Models\Brands\Brand;
use App\Http\Controllers\Controller;
use App\Models\User;


class DashboardController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $data = [
            'countCustomer' => User::query()->role('customer')->count(),
            'countProduct' => Product::count(),
            'countCategory' => Category::query()->whereNull('parent_id')->count(),
            'countOrder' => Order::count(),

            'product' => Product::latest()->take(4)->get(),
            'customer' => User::query()->latest()->role('customer')->take(4)->get(),
            'category' => Category::latest()->take(4)->get(),
            'order' => Order::latest()->take(4)->get(),
            'brand' => Brand::latest()->take(4)->get(),
        ];


        return view('admin.dashboard', $data);
    }
}
