<?php

namespace App\Http\Controllers\Admin\Customer;

use App\Http\Controllers\Controller;
use App\Mail\UserEmail;
use App\Models\User;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class CustomerEmailController extends Controller
{
    public function show(User $customer)
    {
        return view('admin.customer.email', compact('customer'));
    }

    public function send(Request $request, User $customer): RedirectResponse
    {
        $request->validate([
            'subject' => 'required',
            'message' => 'required',
        ]);

        $data = $request->all();

        Mail::to($customer)->send(new UserEmail($data['subject'], $data['message']));

        return redirect()->to($request->url)->with('success', 'Email Sent Successfully!');
    }
}
