<?php

namespace App\Http\Controllers\Admin\Customer;

use App\DataTables\CustomersDataTable;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class CustomerController extends Controller
{
    public function index(CustomersDataTable $table)
    {
        return $table->render('admin.customer.index');
    }

    public function create()
    {
        return view('admin.customer.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required|email|unique:customers',
            'address' => 'required',
            'password' => 'required',
            'status' => 'required',
        ]);

        $data = $request->all();
        $data['date'] = date('Y-m-d');
        User::create($data);

        return redirect()->route('customers.index')->with('success', 'Customer Created Successfully!');
    }

    public function edit(User $customer)
    {
        return view('admin.customer.edit', compact('customer'));
    }

    public function update(Request $request, User $customer)
    {
        $request->validate([
            'name' => 'required',
            'email' => "required|email|unique:customers,email,$customer->id",
            'address' => 'required',
            'status' => 'required',
        ]);

        $customer->update($request->all());

        return redirect()->route('customers.index')->with('success', 'Customer Updated Successfully');
    }

    public function destroy(User $customer)
    {
        $customer->delete();

        return back()->with('info', 'Customer Deleted!');
    }
}
