<?php

namespace App\Http\Controllers\Admin\Common;

use App\DataTables\FAQDataTable;
use App\Http\Controllers\Controller;
use App\Models\Commons\Faq;
use Illuminate\Http\Request;

class FaqController extends Controller
{
    public function index(FAQDataTable $table)
    {
        return $table->render('admin.commons.faq.index');
    }


    public function create()
    {
        return view('admin.commons.faq.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required',
            'body' => 'required',
        ]);

        Faq::create($data);

        return redirect()->route('common.faqs.index')->with('success', 'FAQ Created Successfully!');
    }


    public function edit(Faq $faq)
    {
        return view('admin.commons.faq.edit', compact('faq'));
    }


    public function update(Request $request, Faq $faq)
    {
        $data = $request->validate([
            'name' => 'required',
            'body' => 'required',
        ]);

        $faq->update($data);

        return redirect()->route('common.faqs.index')->with('success', 'FAQ Updated Successfully!');
    }

    public function destroy(Faq $faq)
    {
        $faq->delete();

        return back()->with('info', 'FAQ Deleted!');
    }
}
