<?php

namespace App\Http\Controllers\Admin\Category;

use App\DataTables\CategoryDataTable;
use App\DataTables\SubcategoryDataTable;
use App\Http\Controllers\Controller;
use App\Models\Categories\Category;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;

class CategoryController extends Controller
{
    public function index(CategoryDataTable $table)
    {
        return $table->render('admin.categories.index');
    }

    public function create()
    {
        return view('admin.categories.create');
    }

    public function store(Request $request): RedirectResponse
    {
        $data = $request->validate([
            'name' => 'required',
            'image' => 'required|image',
            'status' => 'required',
            'type' => '',
        ]);

        $data['image'] = $this->fileService->store('image', 'categories');
        $data['banner1'] = $this->fileService->store('banner1', 'categories');
        $data['banner2'] = $this->fileService->store('banner2', 'categories');

        Category::query()->create($data);

        return redirect()->route('categories.index')->with('success', 'Category Created!');
    }

    public function show(Category $category, SubcategoryDataTable $table)
    {
        return $table->render('admin.categories.child.index', compact('category'));
    }

    public function edit(Category $category)
    {
        return view('admin.categories.edit', compact('category'));
    }

    public function update(Request $request, Category $category): RedirectResponse
    {
        $data = $request->validate([
            'name' => 'required',
            'image' => 'image',
            'status' => 'required',
            'type' => '',
        ]);

        $data['image'] = $this->fileService->checkAndStore('image', 'categories', $category->image);
        $data['banner1'] = $this->fileService->checkAndStore('banner1', 'categories', $category->banner1);
        $data['banner2'] = $this->fileService->checkAndStore('banner2', 'categories', $category->banner2);

        $category->update($data);

        return redirect()->to($request->url)->with('success', 'Category Updated!');
    }

    public function destroy(Category $category): RedirectResponse
    {
        $this->fileService->delete($category->image);
        $this->fileService->delete($category->banner1);
        $this->fileService->delete($category->banner2);
        $category->delete();

        return back()->with('info', 'Category Deleted');
    }
}
