<?php

namespace App\Http\Controllers\Admin\Brand;

use App\DataTables\BrandDataTable;
use App\Models\Brands\Brand;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class BrandController extends Controller
{
    public function index(BrandDataTable $table)
    {
        return $table->render('admin.brand.index');
    }

    public function create()
    {
        return view('admin.brand.create');
    }

    public function store(Request $request)
    {
        $data = $request->all();
        $data['image'] = $this->fileService->store('image', 'brands');
        Brand::create($data);

        return redirect()->route('brands.index')->with('success', 'Barand Inserted Successfully!');
    }

    public function edit(Brand $brand)
    {
        return view('admin.brand.edit', compact('brand'));
    }

    public function update(Request $request, Brand $brand)
    {
        $data = $request->all();
        $data['image'] = $this->fileService->checkAndStore('image', 'brands', $brand->image);
        $brand->update($data);

        return redirect()->route('brands.index')->with('success', 'Barand Updated Successfully!');
    }

    public function destroy(Brand $brand)
    {
        $this->fileService->delete($brand->image);
        $brand->delete();

        return redirect()->route('brands.index')->with('info', 'Barand Deleted!');
    }
}
