<?php

namespace App\Http\Controllers\API\Vendor\Requirement;

use App\Http\Controllers\Controller;
use App\Http\Resources\Product\RequirementResource;
use App\Models\Products\Product;
use App\Models\Products\ProductRequirement;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;
use Illuminate\Http\Request;

class RequirementController extends Controller
{
    public function index(): AnonymousResourceCollection
    {
        $requirements = ProductRequirement::query()
            ->with(['product', 'variant'])
            ->latest()
            ->get();

        return RequirementResource::collection($requirements);
    }

    public function store(Request $request)
    {
        $requiredProduct = Product::query()->find($request->product_id);
        $product = $requiredProduct->replicate();

        $product->save();

        $data['vendor_id'] = auth()->id();
        $data['status'] = 'inactive';
        $data['in_stock'] = false;

        $product->update($data);

        $product->fresh()->variants()->create([
            'unit' => $request->unit,
            'mrp' => $request->mrp,
            'description' => 'From Vendor',
        ]);
    }
}
