<?php

namespace App\Http\Controllers\API\Vendor\Invoice;

use App\Http\Controllers\Controller;
use App\Http\Resources\Address\AddressResource;
use App\Http\Resources\Customer\CustomerResource;
use App\Http\Resources\Delivery\DeliveryResource;
use App\Http\Resources\Order\OrderResource;
use App\Models\Delivery\Delivery;
use App\Models\Orders\Order;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;

class InvoiceController extends Controller
{
    public function index(): AnonymousResourceCollection
    {
        $orders = Order::query()
            ->where('vendor_id', auth()->id())
            ->latest()
            ->get();

        return OrderResource::collection($orders);
    }

    public function show($id): array
    {
        $order = Order::query()
            ->where('id', $id)
            ->with('customer')
            ->with('address')
            ->first();

        $deliveries = Delivery::query()
            ->where('order_id', $id)
            ->with(['product', 'variation'])
            ->get();

        return [
            'order' => OrderResource::make($order),
            'customer' => CustomerResource::make($order->customer),
            'address' => AddressResource::make($order->address),
            'deliveries' => DeliveryResource::collection($deliveries),
        ];
    }
}
