<?php

namespace App\Http\Controllers\API\Vendor\Category;

use App\Http\Controllers\Controller;
use App\Http\Resources\Category\CategoryResource;
use App\Models\Categories\Category;
use Illuminate\Http\Request;

class CategoryController extends Controller
{
    public function index()
    {
        $categories = Category::query()
            ->whereNull('parent_id')
            ->with('child')
            ->get();

        return CategoryResource::collection($categories);
    }
}
