<?php

namespace App\Http\Controllers\API\Delivery\Wallet;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;

class WalletController extends Controller
{
    public function show()
    {
        return User::query()->find(auth()->id())->wallet;
    }

    public function coupon()
    {
        $this->transaction->coupon(auth()->id());
    }

    public function transfer(Request $request)
    {
        $amount = $request->amount;

        $this->transaction->transfer(auth()->id(), $request->user_id, $amount);
    }

    public function reserve(Request $request)
    {
        $mode = $request->mode;
        $amount = $request->amount;

        if ($mode == 'withdraw') {
            $this->transaction->unreserve(auth()->id(), $amount);
        } else {
            $this->transaction->reserve(auth()->id(), $amount);
        }
    }
}
