<?php

namespace App\Http\Controllers\API\Delivery\History;

use App\Http\Controllers\Controller;
use App\Http\Resources\Delivery\DeliveryOrderResource;
use App\Models\Orders\Order;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;

class HistoryController extends Controller
{
    public function index(): AnonymousResourceCollection
    {
        $orders = Order::query()
            ->has('address')
            ->with('address')
            ->with('deliveries', function ($query) {
                return $query
                    ->where('delivery_id', auth()->id())
                    ->has('product')
                    ->has('variation')
                    ->with(['product', 'variation']);
            })
            ->has('deliveries')
            ->get()
            ->filter(function ($order, $key) {
                return count($order->deliveries) > 0;
            });

        return DeliveryOrderResource::collection($orders);
    }
}
