<?php

namespace App\Http\Controllers\API\Customer\Profile;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class ProfileController extends Controller
{
    public function update(Request $request)
    {
        $data = $request->all();
        $customer = User::query()->find(auth()->id());

        $validator = Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'email' => "email|unique:customers,email, $customer->id",
            'phone' => "required|digits:10|unique:customers,phone, $customer->id",
            'password' => ['string', 'min:6'],
        ]);

        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 422);
        }

        if (isset($data['password'])) $data['password'] = Hash::make($data['password']);

        $customer->update($data);

        return $customer->fresh();
    }
}
