<?php

namespace App\Http\Controllers\API\Customer\Product;

use App\Http\Controllers\Controller;
use App\Http\Resources\Product\ProductResource;
use App\Models\Products\Product;
use App\Models\Products\Search;
use Illuminate\Http\Request;

class SearchController extends Controller
{
    public function index()
    {
        $query = request('query');

        Search::query()->create([
            'query' => $query ?? '',
            'count' => '0',
            'customer_id' => auth()->id(),
        ]);

        if ($query == '') return [];

        $products = Product::query()
            ->where('name', 'LIKE', '%' . $query . '%')
            ->has('variants')
            ->active()
            ->relations()
            ->get();


        return ProductResource::collection($products);
    }
}
