<?php

namespace App\Http\Controllers\API\Customer\Product;

use App\Http\Controllers\Controller;
use App\Http\Resources\Product\ProductDetailsResource;
use App\Http\Resources\Product\ProductResource;
use App\Models\Products\Product;
use App\Models\Products\Search;

class ProductController extends Controller
{
    public function index()
    {
        $type = request('type');
        $id = request('id');


        if (!isset($type) && !isset($id)) {
            $products = Product::query()
                ->active()
                ->safe()
                ->get();
        } else {
            $products = Product::query()
                ->where($type, $id)
                ->has('variants')
                ->active()
                ->relations()
                ->get();
        }

        return ProductResource::collection($products);
    }

    public function show($id)
    {
        $product = Product::query()
            ->where('id', $id)
            ->relations()
            ->first();

        return ProductDetailsResource::make($product);
    }

    public function search()
    {
        $query = request('query');

        Search::query()->create([
            'query' => $query ?? '',
            'count' => '0',
            'customer_id' => auth()->id(),
        ]);

        if ($query == '') return [];

        $products = Product::query()
            ->where('name', 'LIKE', '%' . $query . '%')
            ->has('variants')
            ->active()
            ->relations()
            ->get();


        return ProductResource::collection($products);
    }
}
