<?php

namespace App\Http\Controllers\API\Customer\Package;

use App\Http\Controllers\Controller;
use App\Http\Resources\Package\PackageProductResource;
use App\Http\Resources\Package\PackageResource;
use App\Models\Packages\Package;

class PackageController extends Controller
{
    public function index()
    {
        $type = request('type');
        $id = request('id');

        if (!isset($type) && !isset($id)) {
            return Package::all();
        }

        if ($type == 'duration') {
            return Package::where([
                ['type', 'bazar'],
                ['duration', $id]
            ])->get();
        }

        return Package::where('type', 'food')->get();
    }

    public function show(Package $package)
    {
        return [
            'package' => PackageResource::make($package),
            'products' => PackageProductResource::collection($package->products),
        ];
    }
}
