<?php

namespace App\Http\Controllers\API\Customer\Home;

use App\Http\Controllers\Controller;
use App\Http\Resources\Category\CategoryResource;
use App\Http\Resources\Package\PackageGroupResource;
use App\Http\Resources\Product\DealResource;
use App\Http\Resources\Product\ProductResource;
use App\Models\Banners\Banner;
use App\Models\Brands\Brand;
use App\Models\Categories\Category;
use App\Models\Deals\Deal;
use App\Models\Packages\PackageGroup;
use App\Models\Products\Product;
use App\Models\Sliders\Slider;

class HomeController extends Controller
{
    public function __invoke()
    {
        $banners = Banner::all();
        $sliders = Slider::whereParentId(null)->active()->with(['child' => $this->active])->active()->get();
        $brands = Brand::active()->get();
        $sponsoredBrands = Brand::query()
            ->where('type', Brand::TYPE_SPONSOR)
            ->active()
            ->get();

        $products = Product::query()
            ->whereNotNull('place')
            ->has('variants')
            ->whereIn('place', ['home1', 'home2', 'home3'])
            ->active()
            ->relations()
            ->get()
            ->groupBy('place');


        $categories = Category::query()
            ->whereNull('parent_id')
            ->whereNull('type')
            ->active()
            ->get();

        $special = Category::query()
            ->whereNull('parent_id')
            ->whereNotNull('type')
            ->active()
            ->get();

        $packageGroup = PackageGroup::query()
            ->orderByDesc('sort')
            ->with('packages')
            ->get();

        $deals = Deal::with('products')->get();

        return [
            'banners' => $banners,
            'sliders' => $sliders,
            'categories' => CategoryResource::collection($categories),
            'special' => CategoryResource::collection($special),
            'brands' => $brands,
            'sponsored_brands' => $sponsoredBrands,
            'products' => [
                'home1' => isset($products['home1']) ? ProductResource::collection($products['home1']) : null,
                'home2' => isset($products['home2']) ? ProductResource::collection($products['home2']) : null,
                'home3' => isset($products['home3']) ? ProductResource::collection($products['home3']) : null,
            ],
            'packages' => PackageGroupResource::collection($packageGroup),
            'deals' => DealResource::collection($deals),
        ];
    }
}
