<?php

namespace App\Http\Controllers\API\Customer\Counter;

use App\Http\Controllers\Controller;
use App\Models\Orders\Order;
use Illuminate\Http\Request;

class CounterController extends Controller
{
    public function readyPlanCount(): int
    {
        return Order::query()
            ->where('status', '!=', Order::ORDER_FAILED)
            ->where('customer_id', auth()->id())
            ->whereNotNull('package_id')
            ->count();
    }
}
