<?php

namespace App\Http\Controllers\API\Customer\Common;

use App\Http\Controllers\Controller;
use App\Http\Resources\Commons\DonationResource;
use App\Models\Commons\Common;
use App\Models\Commons\Donation;
use App\Models\Commons\Faq;
use App\Models\Complints\Complint;
use Illuminate\Http\Request;

class CommonController extends Controller
{
    public function faq()
    {
        return Faq::all();
    }

    public function privacy()
    {
        $privacy = Common::where('type', 'privacy')->first();

        if (!isset($privacy)) return '';

        return $privacy->body;
    }

    public function terms()
    {
        $terms = Common::where('type', 'terms')->first();

        if (!isset($terms)) return '';

        return $terms->body;
    }

    public function info()
    {
        $terms = Common::where('type', request()->type)->first();

        if (!isset($terms)) return '';

        return $terms->body;
    }

    public function complain(Request $request)
    {
        $data = $request->all();

        Complint::create($data);
    }

    public function donations()
    {
        $donations = Donation::query()->latest()->get();

        return DonationResource::collection($donations);
    }
}
