<?php

namespace App\Http\Controllers\API\Customer\Category;

use App\Http\Resources\Category\CategoryResource;
use App\Http\Resources\Product\DealResource;
use App\Http\Resources\Product\ProductResource;
use App\Models\Deals\Deal;
use App\Models\Banners\Banner;
use App\Models\Products\Product;
use App\Models\Categories\Category;
use App\Http\Controllers\Controller;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;

class CategoryController extends Controller
{
    public function index(): array
    {
        $type = request('type');

        $categories = Category::query()
            ->whereNull('parent_id')
            ->where('type', $type)
            ->active()
            ->get();

        $banners = Banner::all();

        $products = Product::query()
            ->whereNotNull('place')
            ->where('place', 'category')
            ->active()
            ->safe()
            ->get();

        $deal = Deal::with('products')->latest()->first();

        return [
            'banners' => $banners,
            'categories' => CategoryResource::collection($categories),
            'products' => ProductResource::collection($products),
            'deal' => DealResource::make($deal),
        ];
    }

    public function show(Category $category): array
    {
        $categories = Category::query()
            ->where('parent_id', $category->id)
            ->whereNull('type')
            ->active()
            ->get();

        $products = Product::query()
            ->where('category_id', $category->id)
            ->active()
            ->safe()
            ->get();

        return [
            'categories' => CategoryResource::collection($categories),
            'products' => ProductResource::collection($products),
        ];
    }

    public function showSubcategory(Category $category, Category $subcategory): array
    {
        $categories = Category::query()
            ->where('id', $category->id)
            ->with('child')
            ->active()
            ->get();

        $products = Product::query()
            ->where('subcategory_id', $subcategory->id)
            ->active()
            ->safe()
            ->get();

        return [
            'categories' => CategoryResource::collection($categories),
            'products' => ProductResource::collection($products),
        ];
    }

    public function showSpecial(Category $category): AnonymousResourceCollection
    {
        $products = Product::query()
            ->where('subcategory_id', $category->id)
            ->active()
            ->safe()
            ->get();

        return ProductResource::collection($products);
    }
}
