<?php

namespace App\Http\Controllers\API\Customer\Basket;

use App\Exceptions\WalletException;
use App\Models\Delivery\Delivery;
use App\Models\Orders\Order;
use App\Models\Orders\OrderProduct;
use App\Models\Orders\OrderVariation;
use Illuminate\Http\Request;
use App\Models\Packages\Basket;
use App\Http\Controllers\Controller;

class BasketController extends Controller
{
    public function index()
    {
        return Basket::latest()->get();
    }

    public function show(Basket $basket)
    {
        return $basket;
    }

    public function store(Request $request)
    {
        $orderId = $request->order_id;

        $order = Order::where('id', $orderId)->first();
        $products = json_decode($request->products);

        $total = 0;

        // Calculate Total
        foreach ($products as $product) {
            $total += $product->price;
        }

        try {
            $this->transaction->debitPackage(auth()->id(), $total);
        } catch (WalletException $e) {
            return response()->json($e->getMessage(), 400);
        }

        foreach ($products as $product) {
            $productVariant = $product->variant;

            $orderProduct = OrderProduct::create([
                'order_id' => $orderId,

                'product_id' => $product->product_id,
                'price' => $product->price,

                'total_unit' => 'NOT INCLUDED',
            ]);

            $orderVariation = OrderVariation::create([
                'order_product_id' => $orderProduct->id,

                'variant_id' => $productVariant->variant_id,
                'quantity' => $productVariant->quantity,
                'total' => $productVariant->total,

                'remaining_quantity' => 0,
            ]);

            Delivery::query()->create([
                'order_id' => $orderId,

                'customer_id' => auth()->id(),

                'postcode' => $order->address->pin,
                'area' => $order->address->road,

                'product_id' => $orderProduct->id,

                'date' => $product->date,
                'time' => $request->time,

                'variation_id' => $orderVariation->id,
                'quantity' => $orderVariation->quantity,

                'status' => 'confirmed',
            ]);
        }

        $order->update([
            'mrp' => $total + $order->mrp['amount'],
            'total' => $total + $order->total['amount'],
        ]);

        return response()->json('Order Confirmed!');
    }
}
