<?php

namespace App\DataTables;

use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use App\Models\Wallets\Wallet;
use Yajra\DataTables\Services\DataTable;

class WalletsDataTable extends DataTable
{
    public function dataTable($query)
    {
        return datatables()
            ->eloquent($query)
            ->addColumn('actions', 'admin.wallet.action')
            ->rawColumns(['status', 'actions']);
    }

    public function query(Wallet $model)
    {
        return $model->newQuery();
    }

    public function html()
    {
        return $this->builder()
            ->setTableId('wallets-table')
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->pageLength(20)
            ->dom('Bfrtip')
            ->orderBy(0)
            ->buttons(
                Button::make('edit'),
                Button::make('delete'),
            );
    }

    protected function getColumns()
    {
        return [
            Column::make('id'),
            Column::make('blnc'),
            Column::make('actions'),
        ];
    }

    protected function filename()
    {
        return 'wallets_' . date('YmdHis');
    }
}
