<?php

namespace App\DataTables;

use App\Models\Products\Product;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Html\Editor\Editor;
use Yajra\DataTables\Html\Editor\Fields;
use Yajra\DataTables\Services\DataTable;

class VendorProductDatatable extends DataTable
{
    public function dataTable($query)
    {
        return datatables()
            ->eloquent($query)
            ->editColumn('image', 'admin.shared.image')
            ->editColumn('status', 'admin.shared.status')
            ->addColumn('actions', 'admin.vendor.products.action')
            ->rawColumns(['image', 'actions', 'status']);
    }

    public function query(Product $model)
    {
        return $model->newQuery()
            ->where('vendor_id', request('vendor')->id)
            ->with('category');
    }

    public function html()
    {
        return $this->builder()
            ->setTableId('vendorproductdatatable-table')
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->dom('Bfrtip')
            ->orderBy(1)
            ->buttons(
                Button::make('create'),
                Button::make('export'),
                Button::make('print'),
                Button::make('reset'),
                Button::make('reload')
            );
    }

    protected function getColumns()
    {
        return [
            Column::make('id'),
            Column::make('name'),
            Column::make('category.name')->title('Category'),
            Column::make('image'),
            Column::make('status'),
            Column::make('actions'),
        ];
    }

    protected function filename()
    {
        return 'VendorProduct_' . date('YmdHis');
    }
}
