<?php

namespace App\DataTables;

use App\Models\Categories\Category;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Services\DataTable;

class SubcategoryDataTable extends DataTable
{
    public function dataTable($query)
    {
        return datatables()
            ->eloquent($query)
            ->editColumn('image', 'admin.shared.image')
            ->editColumn('status', 'admin.shared.status')
            ->addColumn('actions', 'admin.categories.child.action')
            ->rawColumns(['image', 'status', 'actions']);
    }

    public function query(Category $model)
    {
        return $model->newQuery()->where('parent_id', request('category')->id);
    }

    public function html()
    {
        return $this->builder()
            ->setTableId('subcategory-table')
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->dom('Bfrtip')
            ->orderBy(0)
            ->buttons(
                Button::make('create'),
                Button::make('export'),
                Button::make('print'),
                Button::make('reset'),
                Button::make('reload')
            );
    }

    protected function getColumns()
    {
        return [
            Column::make('id'),
            Column::make('name'),
            Column::make('image'),
            Column::make('status'),
            Column::make('actions'),
        ];
    }

    protected function filename()
    {
        return 'Subcategory_' . date('YmdHis');
    }
}
