<?php

namespace App\DataTables;

use App\Models\Products\ProductRequirement;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Services\DataTable;

class ProductRequirementDataTable extends DataTable
{
    public function dataTable($query)
    {
        return datatables()
            ->eloquent($query)
            ->addColumn('actions', 'admin.products.requirement.action')
            ->rawColumns(['actions']);
    }

    public function query(ProductRequirement $model)
    {
        return $model->newQuery()->with(['product', 'variant']);
    }

    public function html()
    {
        return $this->builder()
            ->setTableId('productrequirement-table')
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->dom('Bfrtip')
            ->orderBy(1)
            ->buttons(
                Button::make('create'),
                Button::make('export'),
                Button::make('print'),
                Button::make('reset'),
                Button::make('reload')
            );
    }

    protected function getColumns()
    {
        return [
            Column::make('id'),
            Column::make('product.name'),
            Column::make('variant.unit'),
            Column::make('actions'),
        ];
    }

    protected function filename()
    {
        return 'ProductRequirement_' . date('YmdHis');
    }
}
