<?php

namespace App\DataTables;

use App\Models\Packages\PackageGroup;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Services\DataTable;

class PackageGroupDataTable extends DataTable
{

    public function dataTable($query)
    {
        return datatables()
            ->eloquent($query)
            ->editColumn('status', 'admin.shared.status')
            ->addColumn('actions', 'admin.package.group.action')
            ->rawColumns(['status', 'actions']);
    }


    public function query(PackageGroup $model)
    {
        return $model->newQuery();
    }


    public function html()
    {
        return $this->builder()
            ->setTableId('packagegroup-table')
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->dom('Bfrtip')
            ->orderBy(1)
            ->buttons(
                Button::make('create'),
                Button::make('export'),
                Button::make('print'),
                Button::make('reset'),
                Button::make('reload')
            );
    }


    protected function getColumns()
    {
        return [
            Column::make('id'),
            Column::make('name'),
            Column::make('status'),
            Column::make('actions'),
        ];
    }


    protected function filename()
    {
        return 'PackageGroup_' . date('YmdHis');
    }
}
