<?php

namespace App\DataTables;

use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use App\Models\Categories\Category;
use Yajra\DataTables\Services\DataTable;

class CategoryDataTable extends DataTable
{
    public function dataTable($query)
    {
        return datatables()
            ->eloquent($query)
            ->editColumn('image', 'admin.shared.image')
            ->editColumn('created_at', function ($data) {
                return $data->created_at->diffForHumans();
            })
            ->editColumn('status', 'admin.shared.status')
            ->addColumn('actions', 'admin.categories.action')
            ->rawColumns(['image', 'status', 'actions']);
    }

    public function query(Category $model)
    {
        return $model->newQuery()->where('parent_id', null);
    }

    public function html()
    {
        return $this->builder()
            ->setTableId('category-table')
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->dom('Bfrtip')
            ->orderBy(4)
            ->buttons(
                Button::make('create'),
                Button::make('export'),
                Button::make('print'),
                Button::make('reset'),
                Button::make('reload')
            );
    }

    protected function getColumns()
    {
        return [
            Column::make('id'),
            Column::make('name'),
            Column::make('image'),
            Column::make('created_at')->title('Created'),
            Column::make('status'),
            Column::make('actions'),
        ];
    }

    protected function filename()
    {
        return 'Category_' . date('YmdHis');
    }
}
